# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.monitor import MonitorManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-monitor
# USAGE
    python create_or_update_scheduled_query_rule.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = MonitorManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="dd4bfc94-a096-412b-9c43-4bd13e35afbc",
    )

    response = client.scheduled_query_rules.create_or_update(
        resource_group_name="QueryResourceGroupName",
        rule_name="perf",
        parameters={
            "location": "eastus",
            "properties": {
                "actions": {
                    "actionGroups": [
                        "/subscriptions/1cf177ed-1330-4692-80ea-fd3d7783b147/resourcegroups/sqrapi/providers/microsoft.insights/actiongroups/myactiongroup"
                    ],
                    "actionProperties": {"Icm.Title": "Custom title in ICM", "Icm.TsgId": "https://tsg.url"},
                    "customProperties": {"key11": "value11", "key12": "value12"},
                },
                "checkWorkspaceAlertsStorageConfigured": True,
                "criteria": {
                    "allOf": [
                        {
                            "dimensions": [
                                {"name": "ComputerIp", "operator": "Exclude", "values": ["192.168.1.1"]},
                                {"name": "OSType", "operator": "Include", "values": ["*"]},
                            ],
                            "failingPeriods": {"minFailingPeriodsToAlert": 1, "numberOfEvaluationPeriods": 1},
                            "metricMeasureColumn": "% Processor Time",
                            "operator": "GreaterThan",
                            "query": 'Perf | where ObjectName == "Processor"',
                            "resourceIdColumn": "resourceId",
                            "threshold": 70,
                            "timeAggregation": "Average",
                        }
                    ]
                },
                "description": "Performance rule",
                "enabled": True,
                "evaluationFrequency": "PT5M",
                "muteActionsDuration": "PT30M",
                "resolveConfiguration": {"autoResolved": True, "timeToResolve": "PT10M"},
                "scopes": [
                    "/subscriptions/aaf177ed-1330-a9f2-80ea-fd3d7783b147/resourceGroups/scopeResourceGroup1/providers/Microsoft.Compute/virtualMachines/vm1"
                ],
                "severity": 4,
                "skipQueryValidation": True,
                "windowSize": "PT10M",
            },
        },
    )
    print(response)


# x-ms-original-file: specification/monitor/resource-manager/Microsoft.Insights/stable/2023-12-01/examples/createOrUpdateScheduledQueryRule.json
if __name__ == "__main__":
    main()
