# 2022-03-15 Triage Log

Largely a quiet week. The perf improvement highlight is the use of real world crates such as `syn`, `cargo`, and `serde` in the collecting of profile guided optimization (PGO) profiles for LLVM. Previously only `libcore` was used for LLVM, though rustc PGO had more crates involved. This led to some decent improvement in compilation of real world crates (upwards of 5.5%). 

On the regression side, the regressions were all largely small but contained inside of rollups making them hard to diagnose and correct. The perf team continues to work on process improvements that make changes to the compiler land through CI quickly while minimizing perf regressions that can sneak through.

Triage done by **@rylev**.
Revision range: [10dccdc7fcbdc64ee9efe2c1ed975ab8c1d61287..3ba1ebea122238d1a5c613deb1bf60ce24bd8fd8](https://perf.rust-lang.org/?start=10dccdc7fcbdc64ee9efe2c1ed975ab8c1d61287&end=3ba1ebea122238d1a5c613deb1bf60ce24bd8fd8&absolute=false&stat=instructions%3Au)

2 Regressions, 3 Improvements, 3 Mixed; 3 of them in rollups
42 comparisons made in total

#### Regressions

Rollup of 8 pull requests [#94814](https://github.com/rust-lang/rust/pull/94814)
- Arithmetic mean of relevant regressions: 2.1%
- Arithmetic mean of all relevant changes: 1.8%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ba14a836c7038da21f5e102aacc7e6d5964f79a6&end=5f4e0677190b82e61dc507e3e72caf89da8e5e28&stat=instructions:u): 16.8% on `incr-patched: println` builds of `cargo opt`
* Mostly an extremely large regression in compiling optimized builds of `cargo` in an incremental patch scenario.
* Looks like in the impacted test case the regression is largely in codegen
* [#94809](https://github.com/rust-lang/rust/pull/94809) is the only change that meaningful touches codegen and luckily testing whether reverting the change makes a difference should be trivial to do. Left a [comment](https://github.com/rust-lang/rust/pull/94814#issuecomment-1067945114) here.


Rollup of 7 pull requests [#94824](https://github.com/rust-lang/rust/pull/94824)
- Arithmetic mean of relevant regressions: 0.5%
- Arithmetic mean of relevant improvements: -0.3%
- Arithmetic mean of all relevant changes: 0.4%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5f4e0677190b82e61dc507e3e72caf89da8e5e28&end=352e621368c31d7b4a6362e081586cdb931ba020&stat=instructions:u): 1.5% on `incr-unchanged` builds of `unicode_normalization check`
* Unfortunately there are many PRs that could plausibly contribute to the performance change: 
	* [#93950](https://github.com/rust-lang/rust/pull/93950) (Use modern formatting for format! macros)
 	* [#94274](https://github.com/rust-lang/rust/pull/94274) (Treat unstable lints as unknown)
 	* [#94368](https://github.com/rust-lang/rust/pull/94368) ([1/2] Implement macro meta-variable expressions)
* The overall regression seems low enough that I don't think we need to consider reverting though. Unfortunately we don't have a good process for determining the culprit in cases like this where many PRs seem somewhat equally likely to be the cause. 
* Left a comment as such [here](https://github.com/rust-lang/rust/pull/94824#issuecomment-1067957978)


#### Improvements

Improve `AdtDef` interning. [#94733](https://github.com/rust-lang/rust/pull/94733)
- Arithmetic mean of relevant improvements: -0.5%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2c6a29af35a81e20f8af4c32bf1b55c59b89eccd&end=012720ffb075a087b781325d17d1822a340a2f2a&stat=instructions:u): -1.2% on `full` builds of `match-stress-enum doc`


Queryify `is_doc_hidden` [#94897](https://github.com/rust-lang/rust/pull/94897)
- Arithmetic mean of relevant improvements: -0.7%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7eac19c30c9aa69bc3d85a583c117c37c1579de3&end=4800c7816ee1937d028407066d229f74b4673c92&stat=instructions:u): -1.1% on `full` builds of `projection-caching doc`


Gather LLVM PGO profiles from `rustc-perf` suite on real-world crates [#94704](https://github.com/rust-lang/rust/pull/94704)
- Arithmetic mean of relevant improvements: -2.8%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b2763cc4cfa761a1d42cc01c7603ba6a98c09ecd&end=ebed06fcba3b58913a5087039a81478d43b47b2f&stat=instructions:u): -5.6% on `incr-full` builds of `style-servo debug`


#### Mixed

Treat constant values as mir::ConstantKind::Val [#94059](https://github.com/rust-lang/rust/pull/94059)
- Arithmetic mean of relevant regressions: 1.3%
- Arithmetic mean of relevant improvements: -1.0%
- Arithmetic mean of all relevant changes: -0.9%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=01ad0ad653d57a5ccecffb08aff3c5564012f133&end=d7b282b886472413a26ef22c848eda0499d12cd3&stat=instructions:u): -6.6% on `full` builds of `ctfe-stress-4 opt`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=01ad0ad653d57a5ccecffb08aff3c5564012f133&end=d7b282b886472413a26ef22c848eda0499d12cd3&stat=instructions:u): 1.6% on `full` builds of `keccak check`
* Since the regressions are all in secondary benchmarks and relatively small, we consider this to be an improvement rather than a mixed result.


Change several HashMaps to IndexMap to improve incremental hashing performance [#90253](https://github.com/rust-lang/rust/pull/90253)
- Arithmetic mean of relevant regressions: 0.3%
- Arithmetic mean of relevant improvements: -0.8%
- Arithmetic mean of all relevant changes: -0.2%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=af8604faddc44b27a59d1a719ff6ceca8bc145eb&end=c9b45e601065c3fb71a4f67481e912391d075621&stat=instructions:u): -7.5% on `incr-full` builds of `clap-rs check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=af8604faddc44b27a59d1a719ff6ceca8bc145eb&end=c9b45e601065c3fb71a4f67481e912391d075621&stat=instructions:u): 0.6% on `full` builds of `deep-vector check`
* Perf was run previously and it was found that there was a large improvements to clap-rs but otherwise an overall performance wash
* This story has not really changed, so the PR was marked [as triaged](https://github.com/rust-lang/rust/pull/90253#issuecomment-1067975046)


Use MaybeUninit in VecDeque to remove the undefined behavior of slice [#94472](https://github.com/rust-lang/rust/pull/94472)
- Arithmetic mean of relevant regressions: 0.9%
- Arithmetic mean of all relevant changes: -2.0%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c9b45e601065c3fb71a4f67481e912391d075621&end=335ffbfa547df94ac236f5c56130cecf99c8d82b&stat=instructions:u): -10.7% on `incr-patched: println` builds of `tokio-webpush-simple opt`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c9b45e601065c3fb71a4f67481e912391d075621&end=335ffbfa547df94ac236f5c56130cecf99c8d82b&stat=instructions:u): 1.1% on `full` builds of `tokio-webpush-simple opt`
* Dominated by a large improvement in the `tokio-webpush-simple opt incremental patch` test case, the micro benchmarks indicate that this is largely a performance wash (most benchmarks don't seem to show statistical difference and those that do are a mix of small regressions and improvements)
* Given all this, the PR was marked [as triaged](https://github.com/rust-lang/rust/pull/94472#issuecomment-1067983132).


#### Untriaged Pull Requests

- [#94824 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/94824)
- [#94814 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/94814)
- [#94402 Revert "Auto merge of #92419 - erikdesjardins:coldland, r=nagisa"](https://github.com/rust-lang/rust/pull/94402)
- [#94333 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/94333)
- [#94130 Use undef for (some) partially-uninit constants](https://github.com/rust-lang/rust/pull/94130)
- [#94103 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/94103)
- [#94072 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/94072)
- [#93670 Apply noundef attribute to &T, &mut T, Box<T>, bool](https://github.com/rust-lang/rust/pull/93670)
- [#93505 safely `transmute<&List<Ty<'tcx>>, &List<GenericArg<'tcx>>>`](https://github.com/rust-lang/rust/pull/93505)
- [#93466 Make dead code check a query.](https://github.com/rust-lang/rust/pull/93466)
- [#93312 Return an indexmap in `all_local_trait_impls` query](https://github.com/rust-lang/rust/pull/93312)
- [#93298 make `find_similar_impl_candidates` even fuzzier](https://github.com/rust-lang/rust/pull/93298)
- [#93288 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/93288)
- [#93154 debuginfo: Make sure that type names for closure and generator environments are unique in debuginfo.](https://github.com/rust-lang/rust/pull/93154)
- [#93148 Overhaul interning.](https://github.com/rust-lang/rust/pull/93148)
- [#93138 Rollup of 17 pull requests](https://github.com/rust-lang/rust/pull/93138)
- [#93095 Store a `Symbol` instead of an `Ident` in `AssocItem`](https://github.com/rust-lang/rust/pull/93095)
- [#92911 Guard against unwinding in cleanup code](https://github.com/rust-lang/rust/pull/92911)
- [#92896 Update some rustc dependencies to deduplicate them](https://github.com/rust-lang/rust/pull/92896)
- [#92844 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/92844)
- [#92816 Remove deprecated LLVM-style inline assembly](https://github.com/rust-lang/rust/pull/92816)
- [#92805 partially revertish `lazily "compute" anon const default substs`](https://github.com/rust-lang/rust/pull/92805)
- [#92535 Allow unwinding from OOM hooks](https://github.com/rust-lang/rust/pull/92535)
- [#92534 Hash `Ident` spans in all HIR structures](https://github.com/rust-lang/rust/pull/92534)
- [#92356 Add {Add,Sub,Mul,Div,Rem,BitXor,BitOr,BitAnd}{,Assign}<$t> to Saturat…](https://github.com/rust-lang/rust/pull/92356)
- [#92277 rustc_metadata: Stop passing `CrateMetadataRef` by reference (step 1)](https://github.com/rust-lang/rust/pull/92277)
- [#92252 Update pulldown-cmark version to 0.9](https://github.com/rust-lang/rust/pull/92252)
